;*****************************************************************************        
;
;   Module:     menufunc.inc
;               
;   Author:     Mike Hibbett 
;                                                                  
;   Version:    1.0 5/10/03                                                  
;
;               Functions to implement the main menu options
;
;*****************************************************************************        

   

;*****************************************************************************        
;
;   Function :  reportMonth
;               displays the monthly fuel consumption figures
;               This function resides in bank1, so we twiddle the PCLATH bits
;
;   Input:      N/A - this is a menu option
;
;   Output:     N/A - this is a menu option
;
;*****************************************************************************        
reportMonth
    movlw   high reportMonthB1
    movwf   PCLATH
    goto    reportMonthB1
    return
    
    
    
;*****************************************************************************        
;
;   Function :  DeleteReminder
;               scrolls through the stored reminders, allowing one to be
;               deleted.
;               This function resides in bank1, so we twiddle the PCLATH bits
;
;   Input:      N/A - this is a menu option
;
;   Output:     N/A - this is a menu option
;
;*****************************************************************************        
DeleteReminder
    movlw   high DeleteReminderB1
    movwf   PCLATH
    goto    DeleteReminderB1
    
    

;*****************************************************************************        
;
;   Function :  viewReminder
;               scrolls through the stored reminders
;               This function resides in bank1, so we twiddle the PCLATH bits
;
;   Input:      N/A - this is a menu option
;
;   Output:     N/A - this is a menu option
;
;*****************************************************************************        
viewReminders
    clrf    viewType
    movlw   high viewRemindersB1
    movwf   PCLATH
    goto    viewRemindersB1



;*****************************************************************************        
;
;   Function :  addReminder
;               Allows entry of the date / distance and text for a reminder,
;               if there is space to add one.
;               This function resides in bank1, so we twiddle the PCLATH bits
;
;   Input:      N/A - this is a menu option
;
;   Output:     N/A - this is a menu option
;
;*****************************************************************************        
addReminder
    movlw   high addReminderB1
    movwf   PCLATH
    goto    addReminderB1

    
    
;*****************************************************************************        
;
;   Function :  resetCounters
;               prompts the user to clear the eeprom memory 
;
;   Input:      N/A - this is a menu option
;
;   Output:     N/A - this is a menu option
;
;*****************************************************************************        
resetCounters
    call    dspClear
    movlw   st1m12 - st1m1      ; Clear Memory
    call    uiDspStr1
    call    dspLine2
    movlw   st1m11 - st1m1      ; Cancel/Yes
    call    uiDspStr1
    
    call    kbdReadKey
    
    movfw   rawKey
    sublw   '#'                 ; Yes key pressed?
    btfsc   STATUS, Z
    call    eepClear
    return


    
;*****************************************************************************        
;
;   Function :  calibrateClock
;               Entry of the clock calibration factor screen.
;               This function resides in bank1, so we twiddle the PCLATH bits
;
;   Input:      N/A - this is a menu option
;
;   Output:     N/A - this is a menu option
;
;*****************************************************************************        
calibrateClock
    movlw   high calClockB1
    movwf   PCLATH
    goto    calClockB1
    


;*****************************************************************************        
;
;   Function :  enterFuel
;               Entry of the data for a fuel load 
;
;   Input:      N/A - this is a menu option
;
;   Output:     N/A - this is a menu option
;
;*****************************************************************************        
enterFuel
    ; Get the last recorded mileage 
    ; Store it in wordBCDTmpA
    clrf    eepNum
    movlw   0x1b
    movwf   eepAddH
    movlw   0x97
    movwf   eepAddL
    call    eepRead
    movfw   eepData
    movwf   wordBCDTmpA0
    movlw   .1                    ;Increment the EEPROM Adress by 1
    addwf   eepAddL,F
    btfsc   STATUS,C
    incf    eepAddH,F
    call    eepRead
    movfw   eepData
    movwf   wordBCDTmpA1
    movlw   .1                    ;Increment the EEPROM Adress by 1
    addwf   eepAddL,F
    btfsc   STATUS,C
    incf    eepAddH,F
    call    eepRead
    movfw   eepData
    movwf   wordBCDTmpA2
    
    call    dspClear
    call    dspLine2

    movlw   st1m9 - st1m1
    call    uiDspStr1   

    call    dspHome        

    call    readUnits
    call    uiDspDistance
    movlw   ':'
    call    dspPutChar

    movlw   wordBCDTmpA0
    movwf   FSR
    call    uiDspBCDWord

    ; Move cursor to next position
    movfw   distanceDspLen
    addlw   1 + 0x80
    call    dspPutCmd

    movlw   0x00F
    call    dspPutCmd       ; disp on, blinking cursor      
    
    call    kbdReadKey
    
    sublw   '*'
    btfsc   STATUS, Z
    goto    enterFuel
    
    movfw   rawKey
    sublw   '#'
    btfsc   STATUS, Z
    goto    ef_nochange     ; Abort if # key pressed here
    
    movlw   '0'
    subwf   rawKey, W
    movwf   wordBCDTmpA0
    swapf   wordBCDTmpA0, F
    movfw   rawKey
    call    dspPutChar

    call    kbdReadKey
    
    sublw   '*'
    btfsc   STATUS, Z
    goto    enterFuel
    
    movfw   rawKey
    sublw   '#'
    btfsc   STATUS, Z
    goto    ef001           ; Now ask for Fuel load
    
    movlw   '0'
    subwf   rawKey, W
    addwf   wordBCDTmpA0, F
    movfw   rawKey
    call    dspPutChar

    call    kbdReadKey
    
    sublw   '*'
    btfsc   STATUS, Z
    goto    enterFuel
    
    movfw   rawKey
    sublw   '#'
    btfsc   STATUS, Z
    goto    ef001           ; Now ask for Fuel load
    
    movlw   '0'
    subwf   rawKey, W
    movwf   wordBCDTmpA1
    swapf   wordBCDTmpA1, F
    movfw   rawKey
    call    dspPutChar

    call    kbdReadKey
    
    sublw   '*'
    btfsc   STATUS, Z
    goto    enterFuel
    
    movfw   rawKey
    sublw   '#'
    btfsc   STATUS, Z
    goto    ef001           ; Now ask for Fuel load
    
    movlw   '0'
    subwf   rawKey, W
    addwf   wordBCDTmpA1, F
    movfw   rawKey
    call    dspPutChar

    call    kbdReadKey
    
    sublw   '*'
    btfsc   STATUS, Z
    goto    enterFuel
    
    movfw   rawKey
    sublw   '#'
    btfsc   STATUS, Z
    goto    ef001           ; Now ask for Fuel load
    
    movlw   '0'
    subwf   rawKey, W
    movwf   wordBCDTmpA2
    swapf   wordBCDTmpA2, F
    movfw   rawKey
    call    dspPutChar
    
    call    kbdReadKey
    
    sublw   '*'
    btfsc   STATUS, Z
    goto    enterFuel
    
    movfw   rawKey
    sublw   '#'
    btfsc   STATUS, Z
    goto    ef001           ; Now ask for Fuel load
    
    movlw   '0'
    subwf   rawKey, W
    addwf   wordBCDTmpA2, F
    movfw   rawKey
    call    dspPutChar

ef001
    ; Store value (temporarily)

    movlw   0x00C
    call    dspPutCmd       ; disp on, no cursor      

    ; Give a pause for user to see display
    movlw   D'100'
    call    uiWait10ms           

    movlw   0x00F
    call    dspPutCmd       ; disp on, no cursor      
    
ef002
    ; ask for fuel
    clrf    byteBCDTmpA

    call    dspClear
    call    dspLine2

    movlw   st1m9 - st1m1
    call    uiDspStr1   

    call    dspHome        

    call    uiDspVolume
    movlw   ':'
    call    dspPutChar

    movlw   byteBCDTmpA
    movwf   FSR
    call    uiDspBCDByte

    ; Move cursor to next position
    movfw   volumeDspLen
    addlw   1 + 0x80
    call    dspPutCmd
    
    call    kbdReadKey
    
    sublw   '*'
    btfsc   STATUS, Z
    goto    ef002
    
    movfw   rawKey
    sublw   '#'
    btfsc   STATUS, Z
    goto    ef_nochange     ; Abort if # key pressed here
    
    movlw   '0'
    subwf   rawKey, W
    movwf   byteBCDTmpA
    swapf   byteBCDTmpA, F
    movfw   rawKey
    call    dspPutChar

    call    kbdReadKey
    
    sublw   '*'
    btfsc   STATUS, Z
    goto    ef002
    
    movfw   rawKey
    sublw   '#'
    btfsc   STATUS, Z
    goto    ef003           ; Now store values
    
    movlw   '0'
    subwf   rawKey, W
    addwf   byteBCDTmpA, F
    movfw   rawKey
    call    dspPutChar
    
ef003
    movlw   0x00C
    call    dspPutCmd       ; disp on, no cursor      

    ; Give a pause for user to see display
    movlw   D'100'
    call    uiWait10ms           


    ; Now, mileage is in wordBCDTmpA
    ; Fuel is in byteBCDTmpA
        
    clrf    eepNum    
    clrf    eepAddH
    movlw   0x0F                ; # of fuel loads
    movwf   eepAddL
    call    eepRead
    
    movfw   eepData
    movwf   tmpNumRecH
    movlw   0x10                ; # of fuel loads
    movwf   eepAddL
    call    eepRead
    
    movfw   eepData
    movwf   tmpNumRecL

    movlw   0x11                ; Next record add
    movwf   eepAddL
    call    eepRead
    
    movfw   eepData
    movwf   tmpNextRecH
    movlw   0x12                ; Next record add
    movwf   eepAddL
    call    eepRead
    
    movfw   eepData
    movwf   tmpNextRecL
    
    ; We have tmpNextRec and tmpNumRec
    
    ; Get RTC 
    bcf     INTCON, GIE         ; Disable global interrupts
    movfw   daysBCD
    movwf   daysBCDTmp
    movfw   monthsBCD
    movwf   monthsBCDTmp
    movfw   yearsBCD
    movwf   yearsBCDTmp
    movfw   hoursBCD
    movwf   hoursBCDTmp
    bsf     INTCON, GIE         ; Enable global interrupts
    
    ; We have all the data, so store it
    clrf    eepNum    
    movfw   tmpNextRecH
    movwf   eepAddH
    movfw   tmpNextRecL
    movwf   eepAddL
    movfw   daysBCDTmp
    movwf   eepData
    call    eepWrite
    movfw   monthsBCDTmp
    movwf   eepData
    call    eepWrite
    movfw   yearsBCDTmp
    movwf   eepData
    call    eepWrite
    movfw   hoursBCDTmp
    movwf   eepData
    call    eepWrite
    movfw   wordBCDTmpA0
    movwf   eepData
    call    eepWrite
    movfw   wordBCDTmpA1
    movwf   eepData
    call    eepWrite
    movfw   wordBCDTmpA2
    movwf   eepData
    call    eepWrite
    movfw   byteBCDTmpA
    movwf   eepData
    call    eepWrite
    
    ; Are we at the last data location?
    movfw   eepAddH
    sublw   0x15
    btfss   STATUS,Z
    goto    ef004               
    movfw   eepAddL
    sublw   0xF3 - 0x08
    btfss   STATUS,Z
    goto    ef004               ; No, so just add 8

    ; Reset to beginning
    clrf    tmpNextRecH
    movlw   0x13
    movwf   tmpNextRecL
    goto    ef005   
    
ef004                           ; Add 8
    movlw   0x08               
    addwf   tmpNextRecL,F
    btfsc   STATUS,C
    incf    tmpNextRecH,F
    
ef005                           ; Store new address
    clrf    eepAddH
    movlw   0x11
    movwf   eepAddL
    movfw   tmpNextRecH
    movwf   eepData
    call    eepWrite
    movfw   tmpNextRecL
    movwf   eepData
    call    eepWrite
    
    ; Store mileage in 'last recorded mileage' position
    movlw   0x1b
    movwf   eepAddH
    movlw   0x97
    movwf   eepAddL
    movfw   wordBCDTmpA0
    movwf   eepData
    call    eepWrite
    movfw   wordBCDTmpA1
    movwf   eepData
    call    eepWrite
    movfw   wordBCDTmpA2
    movwf   eepData
    call    eepWrite

    ; Increment # of fuel records, if not already at maximum
    ; Maximum is 700, 0x2BC

    movfw   tmpNumRecH
    sublw   0x02
    btfss   STATUS,Z
    goto    ef006
    movfw   tmpNumRecL
    sublw   0xbc
    btfsc   STATUS,Z
    goto    ef007
    
ef006    
    movlw   0x01
    addwf   tmpNumRecL,F
    btfsc   STATUS,C
    incf    tmpNumRecH,F

    clrf    eepAddH
    movlw   0x0F
    movwf   eepAddL
    movfw   tmpNumRecH
    movwf   eepData
    call    eepWrite
    movfw   tmpNumRecL
    movwf   eepData
    call    eepWrite
    
ef007    
    ; If # of records > 1, 
    ;  add fuel load to Total Fuel Load
    ;  subtract current miles from last miles, add to Total Miles
    ; the call Display current average MPG
    
    movfw   tmpNumRecH
    sublw   0x00
    btfss   STATUS, Z
    goto    ef008
    movfw   tmpNumRecL
    sublw   0x01
    btfsc   STATUS, Z
    goto    ef_nochange         ; This is the first record
    
ef008                           ; More than 1 record
    ; Add fuel load to total fuel load
    ; Now, we have the current fuel and miles in byteBCDTMPA and wordBCDTmpA
    ; And we have the new address location in tmpNextRec
    ; Get previous data.
    ; The previous data is therefore at location tmpNextRec - 2
    ; If tmpNextRec = 0x0013, previous = 0x15f3 - 8 - 8 ( ef010 )
    ; If tmpNextRec = 0x0013 + 8, previous = 0x15f3 - 8 ( ef011 )
    ; else previous = tmpNextRec - 16 ( ef009 )
    ; So first, calculate a previous address
    
    movfw   tmpNextRecH
    movwf   tmpPrevRecH
    movfw   tmpNextRecL
    movwf   tmpPrevRecL
    
    movfw   tmpNextRecH
    sublw   0x00
    btfss   STATUS, Z
    goto    ef009               ; Address is not at the beginning, just - 16
    movfw   tmpNextRecL
    sublw   0x13
    btfsc   STATUS, Z
    goto    ef010               ; Address is 0x0013
    movfw   tmpNextRecL
    sublw   0x1B
    btfsc   STATUS, Z
    goto    ef011               ; Address is 0x0013 + 8               
    
ef009                           ; Sub 16
    movlw   0x10
    subwf   tmpPrevRecL, F
    btfss   STATUS, C
    decf    tmpPrevRecH, F
    goto    ef012
    
ef010                           ; previous = 0x15f3 - 8 - 8
    movlw   0x15
    movwf   tmpPrevRecH
    movlw   0xe3
    movwf   tmpPrevRecL
    goto    ef012
    
ef011                           ; previous = 0x15f3 - 8
    movlw   0x15
    movwf   tmpPrevRecH
    movlw   0xeb
    movwf   tmpPrevRecL   
    
ef012                           ; Read data.
    ; We need miles in wordBCDTmpB, fuel in byteBCDTmpB
    ; Skip past the date & time parts of the record
    movlw   0x04
    addwf   tmpPrevRecL,F
    btfsc   STATUS,C
    incf    tmpPrevRecH,F
    
    clrf    eepNum   
    movfw   tmpPrevRecH 
    movwf   eepAddH
    movfw   tmpPrevRecL 
    movwf   eepAddL
    call    eepRead
    movfw   eepData
    movwf   wordBCDTmpB0
    
    movlw   .1                    ;Increment the EEPROM Adress by 1
    addwf   eepAddL,F
    btfsc   STATUS,C
    incf    eepAddH,F
    call    eepRead
    movfw   eepData
    movwf   wordBCDTmpB1

    movlw   .1                    ;Increment the EEPROM Adress by 1
    addwf   eepAddL,F
    btfsc   STATUS,C
    incf    eepAddH,F
    call    eepRead
    movfw   eepData
    movwf   wordBCDTmpB2

    movlw   .1                    ;Increment the EEPROM Adress by 1
    addwf   eepAddL,F
    btfsc   STATUS,C
    incf    eepAddH,F
    call    eepRead
    movfw   eepData
    movwf   byteBCDTmpB
   
    ; We have:
    ; previous miles in wordBCDTmpB, fuel in byteBCDTmpB
    ; current miles in wordBCDTmpA, fuel in byteBCDTmpA
    ; Save copies of both
    movfw   wordBCDTmpB0
    movwf   wordBCDTmpD0
    movfw   wordBCDTmpB1
    movwf   wordBCDTmpD1
    movfw   wordBCDTmpB2
    movwf   wordBCDTmpD2
    movfw   byteBCDTmpA
    movwf   byteBCDTmpC
    movfw   byteBCDTmpB
    movwf   byteBCDTmpD
    
    ; To get mile traveled in this period,
    ; do wordBCDTmpA - wordBCDTmpB
    movlw   HIGH calcBCDSubWord
    movwf   PCLATH    
    call    calcBCDSubWord
    clrf    PCLATH
    
    ; Save a copy of the miles for this load
    movfw   wordBCDTmpA0
    movwf   wordBCDTmpC0
    movfw   wordBCDTmpA1
    movwf   wordBCDTmpC1
    movfw   wordBCDTmpA2
    movwf   wordBCDTmpC2
    
    ; Now add wordBCDTmpA into total miles
    clrf    eepAddH
    movlw   0x09 
    movwf   eepAddL
    call    eepRead
    movfw   eepData
    movwf   wordBCDTmpB0
    movlw   0x0A
    movwf   eepAddL
    call    eepRead
    movfw   eepData
    movwf   wordBCDTmpB1
    movlw   0x0B
    movwf   eepAddL
    call    eepRead
    movfw   eepData
    movwf   wordBCDTmpB2

    movlw   HIGH calcBCDAdd2Words
    movwf   PCLATH    
    call    calcBCDAdd2Words   
    clrf    PCLATH
    
    movlw   0x09 
    movwf   eepAddL
    movfw   wordBCDTmpA0
    movwf   eepData
    call    eepWrite
    movfw   wordBCDTmpA1
    movwf   eepData
    call    eepWrite
    movfw   wordBCDTmpA2
    movwf   eepData
    call    eepWrite
    
    ; Now add byteBCDTmpA into total Fuel
    clrf    eepAddH
    movlw   0x0C 
    movwf   eepAddL
    call    eepRead
    movfw   eepData
    movwf   wordBCDTmpA0
    movlw   0x0D
    movwf   eepAddL
    call    eepRead
    movfw   eepData
    movwf   wordBCDTmpA1
    movlw   0x0E
    movwf   eepAddL
    call    eepRead
    movfw   eepData
    movwf   wordBCDTmpA2

    
    movlw   HIGH calcBCDAddByte2Word
    movwf   PCLATH    
    call    calcBCDAddByte2Word
    clrf    PCLATH
    
    movlw   0x0C 
    movwf   eepAddL
    movfw   wordBCDTmpA0
    movwf   eepData
    call    eepWrite
    movfw   wordBCDTmpA1
    movwf   eepData
    call    eepWrite
    movfw   wordBCDTmpA2
    movwf   eepData
    call    eepWrite
    
    ; Now, all data is stored, and data structures updated.
    ; All we need to do now is display the MPG.
    ; We have:
    ; previous miles in wordBCDTmpD, fuel in byteBCDTmpD
    ; current miles in wordBCDTmpC, fuel in byteBCDTmpC
    
    ; The 'showConsumption' routine that follows
    ; needs miles in  wordBCDTmpA and fuel in wordBCDTmpB
    movfw   wordBCDTmpC0
    movwf   wordBCDTmpA0
    movfw   wordBCDTmpC1
    movwf   wordBCDTmpA1
    movfw   wordBCDTmpC2
    movwf   wordBCDTmpA2
    clrf    wordBCDTmpB0
    clrf    wordBCDTmpB1
    movfw   byteBCDTmpC
    movwf   wordBCDTmpB2
    
    call    dspClear
    call    showConsumption    

    movlw   ' '
    call    dspPutChar
       
    call    readUnits
    call    uiDspDistance
    movlw   '/'
    call    dspPutChar
    call    uiDspVolume
      
    ; Give a pause for user to see display
    movlw   D'255'
    call    uiWait10ms           
    
ef_nochange
    return



;*****************************************************************************        
;
;   Function :  showConsumption
;               Displays the value miles/fuel as a 2 digit value 
;
;   Input:      miles in wordBCDTmpA and fuel in wordBCDTmpB
;
;   Output:     units flag in eepData. distanceDspLen updated
;
;*****************************************************************************        
showConsumption
    movlw   HIGH calcBCDDivWord
    movwf   PCLATH    
    call    calcBCDDivWord
    clrf    PCLATH
    
    movlw   byteBCDTmpA
    movwf   FSR
    call    uiDspBCDByte
    return
    
    

;*****************************************************************************        
;
;   Function :  readUnits
;               A support function to extract the eeprom variable containing
;               the system units. It also updates a variable which indicates
;               the length of the string used to display the units 
;
;   Input:      None
;
;   Output:     units flag in eepData. distanceDspLen updated
;
;*****************************************************************************        
readUnits
    clrf    eepNum    
    clrf    eepAddH
    movlw   0x02
    movwf   eepAddL
    call    eepRead
    
    ; Set constants that define the length of the
    ; displayed prompts
    movlw   5                   ; Miles
    btfss   eepData, 0
    movlw   2                   ; KM
    movwf   distanceDspLen

    movlw   6                   ; Gallons
    btfss   eepData, 1
    movlw   5                   ; Litres
    movwf   volumeDspLen
    return



;*****************************************************************************        
;
;   Function :  setUnits
;               toggles the units used by the s/w.
;
;   Input:      N/A - this is a menu option
;
;   Output:     N/A - this is a menu option
;
;*****************************************************************************        
setUnits
    call    dspClear
       
    call    readUnits
           
    call    uiDspDistance

    movlw   '/'
    call    dspPutChar

    call    uiDspVolume
           
    call    dspLine2

    movlw   st1m10 - st1m1
    call    uiDspStr1

    call    kbdReadKey

    sublw   '*'
    btfss   STATUS, Z
    goto    tstOK
    
    ; No need to set up eeprom address - it is still 
    ; valid from readunits call
    incf    eepData, W
    andlw   0x03
    movwf   eepData
    call    eepWrite 

    movlw   D'1'
    call    uiWait10ms           
    
    goto    setUnits
    
tstOK
    movfw   rawKey
    sublw   '#'
    btfss   STATUS, Z
    goto    setUnits
    return



;*****************************************************************************        
;
;   Function :  blankDisplay
;               Turns the display off, returning to sleep mode 
;
;   Input:      N/A - this is a menu option
;
;   Output:     N/A - this is a menu option
;
;*****************************************************************************        
blankDisplay
    ; Don't need to do a thing for this option
    return



;*****************************************************************************        
;
;   Function :  setClock
;               Modification of the systems realtime clock. 
;
;   Input:      N/A - this is a menu option
;
;   Output:     N/A - this is a menu option
;
;*****************************************************************************        
setClock
    bcf     INTCON, GIE         ; Disable global interrupts
    movfw   daysBCD
    movwf   daysBCDTmp
    movfw   monthsBCD
    movwf   monthsBCDTmp
    movfw   yearsBCD
    movwf   yearsBCDTmp
    movfw   hoursBCD
    movwf   hoursBCDTmp
    movfw   minutesBCD
    movwf   minutesBCDTmp
    bsf     INTCON, GIE         ; Enable global interrupts

    call    dspClear

    movlw   0
    call    uiDspStr1

    call    dspLine2

    movlw   daysBCDTmp
    movwf   FSR
    call    uiDspBCDByte

    movlw   '/'
    call    dspPutChar
    call    uiDspBCDByte
    movlw   '/'
    call    dspPutChar
    call    uiDspBCDByte
    movlw   ' '
    call    dspPutChar
    movlw   ' '
    call    dspPutChar

    call    uiDspBCDByte
    movlw   ':'
    call    dspPutChar
    call    uiDspBCDByte

    call    dspLine2
    movlw   0x00F
    call    dspPutCmd       ; disp on, blinking cursor      

    call    kbdReadKey

    sublw   '*'
    btfsc   STATUS, Z
    goto    setClock
    
    movfw   rawKey
    sublw   '#'
    btfsc   STATUS, Z
    goto    sc_nochange
    
    movlw   '0'
    subwf   rawKey, W
    movwf   daysBCDTmp
    swapf   daysBCDTmp, F
    movfw   rawKey
    call    dspPutChar

    call    kbdReadKey
        
    sublw   '*'
    btfsc   STATUS, Z
    goto    setClock
    
    movfw   rawKey
    sublw   '#'
    btfsc   STATUS, Z
    goto    sc_exit
    
    movlw   '0'
    subwf   rawKey, W
    addwf   daysBCDTmp, F
    movfw   rawKey
    call    dspPutChar

    movlw   '/'
    call    dspPutChar

    call    kbdReadKey

    sublw   '*'
    btfsc   STATUS, Z
    goto    setClock
    
    movfw   rawKey
    sublw   '#'
    btfsc   STATUS, Z
    goto    sc_exit
    
    movlw   '0'
    subwf   rawKey, W
    movwf   monthsBCDTmp
    swapf   monthsBCDTmp, F
    movfw   rawKey
    call    dspPutChar

    call    kbdReadKey
        
    sublw   '*'
    btfsc   STATUS, Z
    goto    setClock
    
    movfw   rawKey
    sublw   '#'
    btfsc   STATUS, Z
    goto    sc_exit
    
    movlw   '0'
    subwf   rawKey, W
    addwf   monthsBCDTmp, F
    movfw   rawKey
    call    dspPutChar

    movlw   '/'
    call    dspPutChar

    call    kbdReadKey

    sublw   '*'
    btfsc   STATUS, Z
    goto    setClock
    
    movfw   rawKey
    sublw   '#'
    btfsc   STATUS, Z
    goto    sc_exit
    
    movlw   '0'
    subwf   rawKey, W
    movwf   yearsBCDTmp
    swapf   yearsBCDTmp, F
    movfw   rawKey
    call    dspPutChar

    call    kbdReadKey
        
    sublw   '*'
    btfsc   STATUS, Z
    goto    setClock
    
    movfw   rawKey
    sublw   '#'
    btfsc   STATUS, Z
    goto    sc_exit
    
    movlw   '0'
    subwf   rawKey, W
    addwf   yearsBCDTmp, F
    movfw   rawKey
    call    dspPutChar

    movlw   ' '
    call    dspPutChar
    movlw   ' '
    call    dspPutChar

    call    kbdReadKey

    sublw   '*'
    btfsc   STATUS, Z
    goto    setClock
    
    movfw   rawKey
    sublw   '#'
    btfsc   STATUS, Z
    goto    sc_exit
    
    movlw   '0'
    subwf   rawKey, W
    movwf   hoursBCDTmp
    swapf   hoursBCDTmp, F
    movfw   rawKey
    call    dspPutChar

    call    kbdReadKey
        
    sublw   '*'
    btfsc   STATUS, Z
    goto    setClock
    
    movfw   rawKey
    sublw   '#'
    btfsc   STATUS, Z
    goto    sc_exit
    
    movlw   '0'
    subwf   rawKey, W
    addwf   hoursBCDTmp, F
    movfw   rawKey
    call    dspPutChar

    movlw   ':'
    call    dspPutChar

    call    kbdReadKey

    sublw   '*'
    btfsc   STATUS, Z
    goto    setClock
    
    movfw   rawKey
    sublw   '#'
    btfsc   STATUS, Z
    goto    sc_exit
    
    movlw   '0'
    subwf   rawKey, W
    movwf   minutesBCDTmp
    swapf   minutesBCDTmp, F
    movfw   rawKey
    call    dspPutChar

    call    kbdReadKey
        
    sublw   '*'
    btfsc   STATUS, Z
    goto    setClock
    
    movfw   rawKey
    sublw   '#'
    btfsc   STATUS, Z
    goto    sc_exit
    
    movlw   '0'
    subwf   rawKey, W
    addwf   minutesBCDTmp, F
    movfw   rawKey
    call    dspPutChar

sc_exit    
    ; Validate the date & time before accepting
    ; TBD

    bcf     INTCON, GIE         ; Disable global interrupts
    movfw   daysBCDTmp
    movwf   daysBCD
    movfw   monthsBCDTmp
    movwf   monthsBCD
    movfw   yearsBCDTmp
    movwf   yearsBCD
    movfw   hoursBCDTmp
    movwf   hoursBCD
    movfw   minutesBCDTmp
    movwf   minutesBCD
    
    ; reset the seconds counter
    clrf    TMR1L
    movlw   0x010
    movwf   TMR1H
    clrf    intTick
    
    bsf     INTCON, GIE         ; Enable global interrupts

    movlw   0x00C
    call    dspPutCmd       ; disp on, no cursor      

    movlw   D'200'              ; Display welcome screen for 2s.
    call    uiWait10ms           ; This also gives 32KHz clock time to start

sc_nochange
    return

      
    
;*****************************************************************************        
;
;   Function :  connectToPC
;               Enables the RS232 user interface
;
;   Input:      N/A - this is a menu option
;
;   Output:     N/A - this is a menu option
;
;*****************************************************************************        
connectToPC
    call    pcPwrOn
    call    dspClear
    movlw   st1m2 - st1m1
    call    uiDspStr1
    call    dspLine2
    movlw   st1m3 - st1m1
    call    uiDspStr1   
    call    pcWelcomeBanner
    call    kbdWaitNoKey
    
    call    pcHandler
    
    call    pcPwrOff
    return    
